/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.property;

import filenet.sim.api.VWSIMSession;
import filenet.sim.toolkit.console.VWSIMCategoryRender;
import filenet.sim.toolkit.console.images.VWSIMImageLoader;
import filenet.sim.toolkit.console.property.VWSIMPublishedDataTableModel;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import simulator.publisher.VWSIMPAQueryResult;
import simulator.publisher.VWSIMPublishedSimulation;
import simulator.publisher.VWSIMQueryToken;

public class VWSIMPublishedDataPane
extends JPanel
implements ActionListener,
ListSelectionListener,
DocumentListener {
    private static final int DEFAULT_SET_SIZE = 50;
    private Frame m_parent = null;
    private VWTable m_table = null;
    private VWSIMPublishedDataTableModel m_tableModel = null;
    private JTextField m_setSizeTextField = null;
    private JLabel m_setIDLabel = null;
    private AbstractButton m_deleteButton = null;
    private AbstractButton m_nextButton = null;
    private int m_currentSet = 1;
    private int m_setSize = 50;
    private boolean m_bSetSizeChanged = false;
    private VWSIMSession m_simSession = null;
    private VWUserInfo m_userInfo = null;
    private String m_currentUser = null;
    private boolean m_bIsSysAdminG = false;
    private VWSIMPAQueryResult m_paQueryResult = null;
    private VWSIMPublishedSimulation[] m_list = null;

    public VWSIMPublishedDataPane(Frame parent, VWSession vwSession, VWSIMSession simSession) {
        try {
            this.m_parent = parent;
            this.m_simSession = simSession;
            this.m_userInfo = vwSession.fetchCurrentUserInfo();
            this.m_currentUser = this.m_userInfo.getName();
            this.m_bIsSysAdminG = vwSession.isMemberOfGroup("SysAdminG");
            this.setLayout(new BorderLayout());
            Dimension dim = VWStringUtils.stringToDimension("650,500");
            if (dim == null) {
                dim = new Dimension(650, 450);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.add((Component)this.createTopPanel(), "First");
            this.add((Component)this.createTablePanel(), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void saveUserPreference() {
        if (this.m_bSetSizeChanged) {
            this.fetchSetSize();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_nextButton) {
            if (this.fetchSetSize()) {
                this.getNextPublishedSimulationSet();
            }
        } else if (obj == this.m_deleteButton && VWMessageDialog.showConfirmDialog(this.m_parent, VWSIMResource.ConfirmDeletePublishedData, VWSIMResource.SelectAnOption, 5) == 1) {
            this.deleteSelectedPublishedSimulations();
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (this.m_table == null) {
                return;
            }
            if (!event.getValueIsAdjusting()) {
                int rowIndex = this.m_table.getSelectedRow();
                if (rowIndex < 0) {
                    if (this.m_deleteButton.isEnabled()) {
                        this.m_deleteButton.setEnabled(false);
                    }
                } else if (!this.m_deleteButton.isEnabled()) {
                    this.m_deleteButton.setEnabled(true);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void changedUpdate(DocumentEvent evt) {
        this.m_bSetSizeChanged = true;
    }

    public void insertUpdate(DocumentEvent evt) {
        this.m_bSetSizeChanged = true;
    }

    public void removeUpdate(DocumentEvent evt) {
        this.m_bSetSizeChanged = true;
    }

    private JToolBar createTopPanel() {
        JToolBar aToolBar = new JToolBar();
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            aToolBar.setLayout(new GridBagLayout());
            aToolBar.setFloatable(false);
            aToolBar.setBorderPainted(false);
            gbConst.fill = 2;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.gridx = -1;
            gbConst.gridy = 0;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(0, 10, 0, 0);
            aToolBar.add((Component)new JLabel(VWSIMResource.MaxReturnedPerSet), gbConst);
            Integer intSetSize = (Integer)this.m_userInfo.getFieldValue("sim_console_publisheddata_setsize");
            if (intSetSize != null) {
                this.m_setSize = intSetSize;
            }
            this.m_setSizeTextField = new JTextField();
            this.m_setSizeTextField.setEnabled(true);
            this.m_setSizeTextField.setEditable(true);
            this.m_setSizeTextField.setColumns(10);
            this.m_setSizeTextField.setText(String.valueOf(this.m_setSize));
            this.m_setSizeTextField.getDocument().addDocumentListener(this);
            aToolBar.add((Component)this.m_setSizeTextField, gbConst);
            VWSIMImageLoader.addToolbarSeparator(aToolBar);
            gbConst.insets = new Insets(0, 10, 0, 0);
            this.m_setIDLabel = new JLabel();
            this.m_setIDLabel.setForeground(SystemColor.textHighlight);
            Font font = this.m_setIDLabel.getFont();
            this.m_setIDLabel.setFont(new Font(font.getName(), 1, 14));
            this.m_setIDLabel.setText(VWSIMResource.SetLabel.toString(String.valueOf(this.m_currentSet)));
            aToolBar.add((Component)this.m_setIDLabel, gbConst);
            this.m_nextButton = VWSIMImageLoader.createToolBarButton("next.gif", VWSIMResource.Next, false);
            this.m_nextButton.addActionListener(this);
            this.m_nextButton.setEnabled(false);
            this.m_nextButton.setRolloverEnabled(true);
            aToolBar.add((Component)this.m_nextButton, gbConst);
            VWSIMImageLoader.addToolbarSeparator(aToolBar);
            this.m_deleteButton = VWSIMImageLoader.createToolBarButton("delete.gif", VWSIMResource.Delete, false);
            this.m_deleteButton.addActionListener(this);
            this.m_deleteButton.setEnabled(false);
            this.m_deleteButton.setRolloverEnabled(true);
            aToolBar.add((Component)this.m_deleteButton, gbConst);
            gbConst.weightx = 1.0;
            aToolBar.add(Box.createHorizontalStrut(10), gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return aToolBar;
    }

    private JPanel createTablePanel() {
        JScrollPane scrollPanel = new JScrollPane();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        try {
            this.createTable();
            scrollPanel.getViewport().add(this.m_table);
            mainPanel.add((Component)scrollPanel, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    private void createTable() {
        try {
            this.getPublishedSimulations();
            this.m_tableModel = new VWSIMPublishedDataTableModel(this.m_list);
            this.m_table = new VWTable(this.m_tableModel);
            this.m_table.setRowSelectionAllowed(true);
            this.m_table.setColumnSelectionAllowed(false);
            this.m_table.getSelectionModel().addListSelectionListener(this);
            this.m_table.setShowGrid(false);
            TableColumnModel columnModel = this.m_table.getColumnModel();
            TableColumn aColumn = columnModel.getColumn(0);
            aColumn.setCellRenderer(new VWSIMCategoryRender());
            aColumn.setMinWidth(20);
            aColumn.setMaxWidth(20);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void getPublishedSimulations() {
        try {
            this.m_paQueryResult = this.m_bIsSysAdminG ? this.m_simSession.getPAQueryResult(null, this.m_setSize) : this.m_simSession.getPAQueryResult(this.m_currentUser, this.m_setSize);
            this.m_list = this.m_paQueryResult != null ? this.m_paQueryResult.getPublishedSimulations() : null;
            if (this.m_list != null && this.m_list.length >= this.m_setSize) {
                this.m_nextButton.setEnabled(true);
                this.m_nextButton.setRolloverEnabled(true);
            } else {
                this.m_nextButton.setEnabled(false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNextPublishedSimulationSet() {
        try {
            if (!this.fetchSetSize()) {
                return;
            }
            this.m_parent.setCursor(new Cursor(3));
            if (this.m_paQueryResult != null) {
                VWSIMQueryToken simQueryToken = this.m_paQueryResult.getQueryToken();
                this.m_paQueryResult = this.m_simSession.getNextPAQueryResult(simQueryToken, this.m_setSize);
                this.m_list = this.m_paQueryResult != null ? this.m_paQueryResult.getPublishedSimulations() : null;
            } else {
                this.m_list = null;
            }
            if (this.m_list != null && this.m_list.length >= this.m_setSize) {
                this.m_nextButton.setEnabled(true);
            } else {
                this.m_nextButton.setEnabled(false);
            }
            this.m_table.clearSelection();
            this.m_tableModel.setData(this.m_list);
            this.m_table.updateUI();
            ++this.m_currentSet;
            this.m_setIDLabel.setText(VWSIMResource.SetLabel.toString(String.valueOf(this.m_currentSet)));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_parent.setCursor(new Cursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedPublishedSimulations() {
        try {
            this.m_parent.setCursor(new Cursor(3));
            int[] rowIndex = this.m_table.getSelectedRows();
            Vector<VWSIMPublishedSimulation> selectedList = new Vector<VWSIMPublishedSimulation>();
            int sz = rowIndex.length;
            for (int i = 0; i < sz; ++i) {
                selectedList.add(this.m_tableModel.getRowItemAt(rowIndex[i]));
            }
            Object[] publishedSimulations = new VWSIMPublishedSimulation[sz];
            selectedList.copyInto(publishedSimulations);
            this.m_simSession.deletePublishedData((VWSIMPublishedSimulation[])publishedSimulations);
            for (int i = sz - 1; i >= 0; --i) {
                this.m_tableModel.removeRow(rowIndex[i]);
            }
            this.m_table.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_parent.setCursor(new Cursor(0));
        }
    }

    private boolean fetchSetSize() {
        boolean bRet = false;
        try {
            String strSetSize = this.m_setSizeTextField.getText();
            if (strSetSize != null && strSetSize.length() > 0) {
                this.m_setSize = Integer.parseInt(strSetSize);
                if (this.m_bSetSizeChanged) {
                    Integer intSetSize = new Integer(this.m_setSize);
                    this.m_userInfo.setFieldValue("sim_console_publisheddata_setsize", intSetSize);
                    this.m_userInfo.save();
                    this.m_bSetSizeChanged = false;
                }
                bRet = true;
            } else {
                JOptionPane.showMessageDialog(this, VWSIMResource.InvalidSetSize, VWSIMResource.Error, 0);
                this.m_setSize = 50;
                this.m_setSizeTextField.setText(String.valueOf(this.m_setSize));
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, VWSIMResource.InvalidSetSize, VWSIMResource.Error, 0);
            this.m_setSize = 50;
            this.m_setSizeTextField.setText(String.valueOf(this.m_setSize));
        }
        catch (Exception ex) {
            this.m_setSize = 50;
            this.m_setSizeTextField.setText(String.valueOf(this.m_setSize));
            VWDebug.logException(ex);
        }
        return bRet;
    }

    protected void releaseResources() {
        this.m_parent = null;
        this.m_setSizeTextField = null;
        this.m_setIDLabel = null;
        this.m_deleteButton = null;
        this.m_nextButton = null;
        this.m_simSession = null;
        this.m_userInfo = null;
        this.m_currentUser = null;
        this.m_paQueryResult = null;
        if (this.m_list != null) {
            for (int i = 0; i < this.m_list.length; ++i) {
                this.m_list[i] = null;
            }
            this.m_list = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        if (this.m_table != null) {
            this.m_table.removeAll();
            this.m_table = null;
        }
        this.removeAll();
    }
}

